#ifndef _IRCCL_H_
#define _IRCCL_H_

#include "alloc.h"
#include "types.h"

typedef class IRC_TCL {
 private:
  IRC_TCL *next, *prev;
 public:
  char chan[ALLOC_CHAN];
  inline IRC_TCL(IRC_TCL *top) 
    { 
#ifdef DEBUG
      fputs("DEBUG - IRC_TCL ctor called\n", stderr);
#endif
      prev = NULL; next = top; if (top!=NULL) top->prev = this; }
  static inline void Delete(IRC_TCL *cl) 
    { 
#ifdef DEBUG
      fputs("DEBUG - IRC_TCL::Delete called\n", stderr);
#endif
      if (cl->next!=NULL)
	cl->next->prev = cl->prev;
      if (cl->prev!=NULL)
	cl->prev->next = cl->next;
      delete [] cl;
    }
  inline IRC_TCL * GetNext() { return next; }
  static inline void Flush(IRC_TCL *top)
    { 
#ifdef DEBUG
      fputs("DEBUG - IRC_TCL::Flush called\n", stderr);
#endif
      if (top->next!=NULL) Flush(top->next); Delete(top); }
} *IRC_PCL;

#endif
